/*
 * Decompiled with CFR 0.152.
 */
package jade.util.leap;

import jade.util.leap.Comparable;
import jade.util.leap.Iterator;
import jade.util.leap.SortedSet;
import java.util.Enumeration;
import java.util.Vector;

public class SortedSetImpl
implements SortedSet {
    private Vector storage = new Vector();
    private transient int modCount = 0;

    public boolean add(Object o) {
        Comparable oc = (Comparable)o;
        if (!this.storage.contains(oc)) {
            ++this.modCount;
            if (this.storage.isEmpty()) {
                this.storage.addElement(oc);
            } else {
                int nelem = this.storage.size();
                int ptr = 0;
                boolean cont = true;
                while (cont) {
                    if (oc.compareTo((Comparable)this.storage.elementAt(ptr)) <= 0) {
                        this.storage.insertElementAt(oc, ptr);
                        cont = false;
                        continue;
                    }
                    if (++ptr != nelem) continue;
                    this.storage.addElement(oc);
                    cont = false;
                }
            }
            return true;
        }
        return false;
    }

    public boolean remove(Object o) {
        ++this.modCount;
        return this.storage.removeElement(o);
    }

    public boolean isEmpty() {
        return this.storage.isEmpty();
    }

    public Object first() {
        return this.storage.firstElement();
    }

    public Iterator iterator() {
        return new SortedSetIterator();
    }

    public Object[] toArray() {
        Object[] returnedArray = new Object[this.storage.size()];
        int i = 0;
        while (i < returnedArray.length) {
            returnedArray[i] = this.storage.elementAt(i);
            ++i;
        }
        return returnedArray;
    }

    public int size() {
        return this.storage.size();
    }

    private class SortedSetIterator
    implements Iterator {
        Enumeration elements;
        private int expectedModCount;

        SortedSetIterator() {
            this.expectedModCount = SortedSetImpl.this.modCount;
            this.elements = SortedSetImpl.this.storage.elements();
        }

        public boolean hasNext() {
            return this.elements.hasMoreElements();
        }

        public Object next() {
            if (SortedSetImpl.this.modCount != this.expectedModCount) {
                throw new RuntimeException();
            }
            return this.elements.nextElement();
        }

        public void remove() {
            throw new RuntimeException();
        }
    }
}

